import Pagination from "./Pagination"; // or wherever your Pagination component is
import React from "react";

type Column = {
  header: string;
  accessor: string;
  className?: string;
  responsiveHide?: boolean;
};

type TableProps = {
  columns: Column[];
  renderRow?: (item: any, index: number) => React.ReactNode;
  data: any[];
};

const Table: React.FC<TableProps> = ({ columns, renderRow, data }) => {
  return (
    <div className="w-full overflow-x-auto">
      {/* Shared scrollable container */}
      <div className="min-w-[900px]">
        {/* Table */}
        <table className="w-full table-auto mt-6">
          <thead>
            <tr className="text-left text-gray-500 text-md">
              {columns.map((col) => (
                <th
                  key={col.accessor}
                  className={`py-4 px-2 ${col.className || ""} ${
                    col.responsiveHide ? "hidden md:table-cell" : ""
                  }`}
                >
                  {col.header}
                </th>
              ))}
            </tr>
          </thead>
          <tbody>
            {Array.isArray(data) && data.length > 0 ? (
              data.map((item, index) =>
                renderRow ? (
                  renderRow(item, index)
                ) : (
                  <tr key={index} className="border-b">
                    {columns.map((col) => (
                      <td
                        key={col.accessor}
                        className={`px-2 py-2 ${
                          col.responsiveHide ? "hidden md:table-cell" : ""
                        }`}
                      >
                        {item[col.accessor]}
                      </td>
                    ))}
                  </tr>
                )
              )
            ) : (
              <tr>
                <td
                  colSpan={columns.length}
                  className="text-center py-4 text-gray-400"
                >
                  No data available
                </td>
              </tr>
            )}
          </tbody>
        </table>

        {/* Pagination */}
        <Pagination />
      </div>
    </div>
  );
};

export default Table;
