'use client';

import { Box, Button, Card, CardContent, Typography } from '@mui/material';

import Image from 'next/image';
import { motion } from 'framer-motion';

export default function EventCard({ event, index }: { event: any; index: number }) {
  return (
    <motion.div
      initial={{ opacity: 0, y: 30 }}
      whileInView={{ opacity: 1, y: 0 }}
      viewport={{ once: true }}
      transition={{ duration: 0.6, delay: index * 0.2 }}
    >
      <Box display="flex" mb={4} position="relative" pl={6}>
        <Box
          sx={{
            position: 'absolute',
            left: 0,
            top: 10,
            width: '10px',
            height: '10px',
            borderRadius: '50%',
            backgroundColor: '#FFC107',
          }}
        />
        <Card sx={{ display: 'flex', width: '100%' }}>
          <Box sx={{ width: 140, position: 'relative' }}>
            <Image src={event.banner_url}  alt={event.title} fill style={{ objectFit: 'cover' }} />
          </Box>
          <CardContent sx={{ flex: 1 }}>
            <Typography variant="body2" color="textSecondary">
              {event.date} | {event.time}
            </Typography>
            <Typography variant="h6" fontWeight="bold" mt={1}>
              {event.title}
            </Typography>
            <Typography variant="body2" color="textSecondary" mt={1} mb={2}>
              {event.description}
            </Typography>
            <Button variant="contained" sx={{ bgcolor: '#FFC107', color: 'white', borderRadius: '20px', fontWeight: 'bold' }}>
              View Event
            </Button>
          </CardContent>
        </Card>
      </Box>
    </motion.div>
  );
}
