"use client";

import "react-calendar/dist/Calendar.css";

import Calendar from "react-calendar";
import Image from "next/image";
import { useState } from "react";

type ValuePiece = Date | null;
type Value = ValuePiece | [ValuePiece, ValuePiece];

const events = [
  {
    id: 1,
    title: "Monthly Friday Kesha",
    time: "01-July-2024-7PM",
    description: "Attending-10.",
  },
  {
    id: 2,
    title: "Theology Propoer 101",
    time: "01-July-2024-7PM",
    description: "Attending-100.",
  },
  {
    id: 3,
    title: "Theology Proper 500",
    time: "01-July-2024-7PM",
    description: "Attending-100.",
  },
];

const EventCalendar = () => {
  const [value, onChange] = useState<Value>(new Date());

  return (
    <div className="bg-white p-4 rounded-md h-[790px] overflow-auto">
      <Calendar
        onChange={onChange}
        value={value}
        className="custom-calendar"
        calendarType="gregory"

      />
      <div className="flex items-center justify-between mt-4">
        <h1 className="text-xl font-semibold">Events</h1>
        <Image src="/moreDark.png" alt="" width={20} height={20} />
      </div>
      <div className="flex flex-col gap-4 mt-4">
        {events.map((event) => (
          <div
            key={event.id}
            className="p-5 rounded-md border-2 border-red-600 border-t-4"
          >
            <div className="flex items-center justify-between">
              <h1 className="font-semibold text-red-500">{event.title}</h1>
              <span className="text-black text-xs">{event.time}</span>
            </div>
            <p className="mt-2 text-black text-sm">{event.description}</p>
          </div>
        ))}
      </div>
    </div>
  );
};

export default EventCalendar;
