"use client";
import Link from "next/link";
import { useEffect, useState } from "react";
import Pagination from "@/components/Pagination";
import Table from "@/components/Table";
import TableSearch from "@/components/TableSearch";
import { getMembers } from "../../../../../lib/api";
import Image from "next/image";
import FormModal from "@/components/FormModal";

type Member = {
  memberId: number;
  name: string;
  gender: string;
  email: string;
  mobile: string;
  status: string;
};

const columns = [
  { header: "Name", accessor: "name" },
  { header: "ID No.", accessor: "memberId", className: "hidden md:table-cell" },
  { header: "Gender", accessor: "gender", className: "hidden lg:table-cell" },
  { header: "Email", accessor: "email", className: "hidden md:table-cell" },
  { header: "Mobile", accessor: "mobile", className: "hidden md:table-cell" },
  { header: "Status", accessor: "status", className: "hidden md:table-cell" },
  { header: "Actions", accessor: "actions" },
];

const Members = () => {
  const [members, setMembers] = useState<Member[]>([]);
  const [loading, setLoading] = useState<boolean>(true);
  const [role, setRole] = useState<string>("");

  useEffect(() => {
    const fetchMembers = async () => {
      try {
        const data = await getMembers();
        setMembers(data);
      } catch (error) {
        console.error("Error fetching members:", error);
      } finally {
        setLoading(false);
      }
    };

    fetchMembers();
    setRole(localStorage.getItem("role") || "user");
  }, []);

  const renderRow = (item: Member) => (
    <tr key={item.memberId} className="border-b border-gray-200 even:bg-slate-50 text-sm hover:bg-slate-50">
      <td className="flex items-center gap-4 p-4">
        <div className="flex flex-col">
          <h3 className="font-semibold">{item.name}</h3>
        </div>
      </td>
      <td className="hidden md:table-cell">{item.memberId}</td>
      <td className="hidden md:table-cell">{item.gender}</td>
      <td className="hidden md:table-cell">{item.email}</td>
      <td className="hidden md:table-cell">{item.mobile}</td>
      <td className="hidden md:table-cell">{item.status}</td>
      <td>
        <div className="flex items-center gap-2">
          <Link href={`/dashboard/list/members/${item.memberId}`}>
             <button className="w-8 h-8 flex items-center justify-center rounded-full bg-white">
                <Image src="/view.png" alt="" width={16} height={16}/>
             </button>
          </Link>
          {role === "admin" && (
            <>
              <FormModal table="Members" type="update" data={item} />
              <FormModal table="Members" type="delete" id={item.memberId} />
            </>
          )}
        </div>
      </td>
    </tr>
  );

  return (
    <div className="bg-white p-4 rounded-md flex-1 m-4 mt-4">
      {/* TOP */}
      <div className="flex items-center justify-between">
        <h1 className="hidden md:block text-lg font-semibold">All Members</h1>
        <div className="flex flex-col md:flex-row items-center gap-4 w-full md:w-auto">
          <TableSearch />
          <div className="flex items-center gap-4 self-end">
            <button className="w-6 h-6 flex items-center justify-center rounded-full bg-red-300">
              <Image src="/filter.png" alt="Filter" width={14} height={14} />
            </button>
            <button className="w-6 h-6 flex items-center justify-center rounded-full bg-red-300">
              <Image src="/sort.png" alt="Sort" width={14} height={14} />
            </button>
            {role === "admin" && <FormModal table="Members" type="create" />}
          </div>
        </div>
      </div>

      {/* LIST */}
      {loading ? (
        <p className="text-center text-gray-500">Loading members...</p>
      ) : (
        <Table columns={columns} renderRow={renderRow} data={members} />
      )}

      {/* PAGINATION */}
      <Pagination />
    </div>
  );
};

export default Members;
