const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL;

export const fetchData = async (endpoint: string, options = {}) => {
  try {
    const response = await fetch(`${API_BASE_URL}/${endpoint}`, {
      credentials: "include",
      ...options,
    });

    if (!response.ok) {
      const errorBody = await response.text(); // or response.json() if your backend sends JSON errors
      throw {
        message: `API Error: ${response.status} ${response.statusText}`,
        status: response.status,
        statusText: response.statusText,
        body: errorBody,
      };
    }

    return await response.json();
  } catch (error) {
    console.error("API Fetch Error:", error);
    throw error;
  }
};
// ✅ Authentication
export const loginUser = async (email: string, password: string) =>
  fetchData("auth/login", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ email, password }),
  });

export const signupUser = async (userData: any) =>
  fetchData("auth/signup", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(userData),
  });

export const getMe = async () => fetchData("auth/me");

// ✅ Logout
export const logoutUser = async () =>
  fetchData("auth/logout", { method: "POST" });

// ✅ Users
export const getUsers = async () => fetchData("users"); // 👈 lowercase 'users'
export const getUserById = async (id: number) => fetchData(`users/${id}`);
export const createUser = async (userData: any) =>
  fetchData("users", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(userData),
  });

export const updateUser = async (id: number, userData: any) =>
  fetchData(`users/${id}`, {
    method: "PUT",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(userData),
  });

export const deleteUser = async (id: number) =>
  fetchData(`users/${id}`, { method: "DELETE" });
// ✅ Members APIs
export const getMembers = async () => fetchData("members");
export const getMemberById = async (id: number) => fetchData(`members/${id}`);
export const createMember = async (memberData: any) =>
  fetchData("members", { method: "POST", body: JSON.stringify(memberData) });
export const updateMember = async (id: number, memberData: any) =>
  fetchData(`members/${id}`, {
    method: "PUT",
    body: JSON.stringify(memberData),
  });
export const deleteMember = async (id: number) =>
  fetchData(`members/${id}`, { method: "DELETE" });

// ✅ Visitors APIs
export const getVisitors = async () => fetchData("visitors");
export const getVisitorById = async (id: number) => fetchData(`visitors/${id}`);
export const createVisitor = async (visitorData: any) =>
  fetchData("visitors", { method: "POST", body: JSON.stringify(visitorData) });
export const updateVisitor = async (id: number, visitorData: any) =>
  fetchData(`visitors/${id}`, {
    method: "PUT",
    body: JSON.stringify(visitorData),
  });
export const deleteVisitor = async (id: number) =>
  fetchData(`visitors/${id}`, { method: "DELETE" });

// ✅ Events APIs
export const getEvents = async () => fetchData("events");
export const getEventById = async (id: number) => fetchData(`events/${id}`);
export const createEvent = async (eventData: any) =>
  fetchData("events", { method: "POST", body: JSON.stringify(eventData) });
export const updateEvent = async (id: number, eventData: any) =>
  fetchData(`events/${id}`, { method: "PUT", body: JSON.stringify(eventData) });
export const deleteEvent = async (id: number) =>
  fetchData(`events/${id}`, { method: "DELETE" });

// ✅ Prayer Requests APIs
export const getPrayers = async () => fetchData("prayers");
export const getPrayersById = async (id: number) => fetchData(`prayers/${id}`);
export const createPrayers = async (prayerData: any) =>
  fetchData("prayers", { method: "POST", body: JSON.stringify(prayerData) });
export const updatePrayers = async (id: number, prayerData: any) =>
  fetchData(`prayers/${id}`, {
    method: "PUT",
    body: JSON.stringify(prayerData),
  });
export const deletePrayers = async (id: number) =>
  fetchData(`prayers/${id}`, { method: "DELETE" });

// ✅ Inquiries APIs
export const getInquiries = async () => fetchData("inquiries");
export const getInquiryById = async (id: number) =>
  fetchData(`inquiries/${id}`);
export const createInquiry = async (inquiryData: any) =>
  fetchData("inquiries", { method: "POST", body: JSON.stringify(inquiryData) });
export const updateInquiry = async (id: number, inquiryData: any) =>
  fetchData(`inquiries/${id}`, {
    method: "PUT",
    body: JSON.stringify(inquiryData),
  });
export const deleteInquiry = async (id: number) =>
  fetchData(`inquiries/${id}`, { method: "DELETE" });

// ✅ Cell Groups APIs
export const getCellGroups = async () => fetchData("cell-groups");
export const getCellGroupById = async (id: number) =>
  fetchData(`cell-groups/${id}`);
export const createCellGroup = async (cellGroupData: any) =>
  fetchData("cell-groups", {
    method: "POST",
    body: JSON.stringify(cellGroupData),
  });
export const updateCellGroup = async (id: number, cellGroupData: any) =>
  fetchData(`cell-groups/${id}`, {
    method: "PUT",
    body: JSON.stringify(cellGroupData),
  });
export const deleteCellGroup = async (id: number) =>
  fetchData(`cell-groups/${id}`, { method: "DELETE" });
