# Milimani A.I.C Church Dashboard

## Getting Started

First, run the development server:

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
# or
bun dev
```

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

# Commit messages
Here are some guidelines when writing a commit message:

1. Separate subject/title from body with a blank line
2. Limit the subject line to 50 characters
3. Capitalize the subject line/Title
4. Do not end the subject line with a period
5. Use hyphens at the beginning of the commit messages in the body
6. Use the imperative mood in the commit messages
7. Wrap the body at 72 characters
8. Use the body to explain what and why vs. how
9. To dive deeper into these guidelines, please view this article by Chris Beams, https://cbea.ms/git-commit/.
# PR Guidelines
## 1. Identify the issue to work on
In order to submit a PR, first identify the bug or feature you want to work on. 
## 2. Creating a branch for the issue
Next, checkout the develop branch and make sure you have pulled the latest changes then create a new branch from develop. 

Here are some guidelines on creating a branch

1. Ensure that the branch uses small letters
2. Use a hyphen to separate each word in a branch
3. Ensure the branch is self explanatory ie. detailed
4. The branch name should be related to the issue assigned

Sample branch name 
 1. enhance-user-card-dimensions
 2. Fix-charts-bug

## 3. Make your changes

Once you have a branch you can now start coding. Make the changes needed for your feature or bug. If you are working on a bug, add test(s) to ensure the bug is tested for and does not recur. If you are working on a feature create new tests for scenarios in your feature.

## 4. Submitting a PR

Before submitting a new PR, please ensure that your current branch is up-to-date with develop. If it is not, merge changes from develop into your branch and fix any merge conflicts before proceeding. If you are having trouble fixing merge conflicts, you can request a team member to help out. Also, add a brief explanation of the changes your PR will make to the codebase. It would also help to add screenshots of the changes you made if you were working on a UI-facing issue.

## 5. Requesting Review

Your PR is now ready. Create the PR and assign a reviewer for your PR. 
